jQuery(document).ready(function($) {
    let editor = ace.edit("editor");
    let currentEditingIndex = null;
    var selected_file = 0;
    var active_class_selector = '';
    var initial = true;
    var script_content_filter = 'false';

    function resetForm() {
        editor.setValue('');
        $('#script-name').val('Unnamed');
        $('#script-type').val('js');
        $('#script-position').val('header_top');
        $('#script-location').val('all');
        $('#script-pages').val('');
        $('#script-shortcode-id').val('');
        $('.context-checkbox').prop('checked', false);
        $('#script-context').val([]);
        $('#css-minimize').prop('checked', false);
        $('#js-base64').prop('checked', false);
        $('#css-minimize-wrapper').hide();
        $('#js-base64-wrapper').hide();
        $('#script-shortcode-id').hide();
        currentEditingIndex = null;
        $('#save-script').text('Save New Script');
    }

    function updateScriptList(search_string = 'false') {
        script_content_filter = search_string;
        $.post(csm_ajax.ajax_url, {
            action: 'get_custom_scripts',
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success) {
                const scripts = response.data;
                let html = '';
                scripts.forEach((script, index) => {

                    if(script_content_filter !== 'false'){
                        var this_code = script.code;
                        var this_name = script.name;
                        if( this_code.toLowerCase().includes(script_content_filter.toLowerCase()) ||
                            this_name.toLowerCase().includes(script_content_filter.toLowerCase())) {
                            hit_ = true;
                        } else {
                            hit_ = false;
                        }
                    } else {
                        hit_ = true;
                    }

                    if(hit_){

                        if(script.type=='javascript'){
                            script_type = 'JS';
                        } else {
                            script_type = script.type.toUpperCase()
                        }
                        active_class_selector = '';
                        if(!initial){
                            if(index === selected_file) {
                                active_class_selector = 'selected';
                            }
                        }
                        initial = false;

                        current_position = script.position.replace(/_/g, ' ').toUpperCase();
                        if(current_position==='HEADER TOP'){
                            poition_output = 'HEADER';
                        } else if(current_position==='FOOTER TOP'){
                            poition_output = 'FOOTER';
                        } else if(current_position==='BODY TOP'){
                            poition_output = 'BODY';
                        } else {
                            poition_output = current_position;
                        }
                        var location_label = script.location;
                        if(script.location ==='specific'){
                            location_label = '';
                        }
                        
                        html += `
                            <div id="${script.id}" class="script-item ${script_type} ${active_class_selector} ${script.active}_state">
                                <div class="script-header">
                                    <span class="script-name">${script.name}</span>
                                    <div class="order_arrows">
                                        <span class="dashicons dashicons-arrow-up-alt2 move-up" ></span>
                                        <span class="dashicons dashicons-arrow-down-alt2 move-down" ></span>
                                    </div>
                                    <div class="script-meta">
                                        <span class="script-type">${script_type}</span>
                                        <span class="script-position">${poition_output}</span>
                                        <button class="button button-small edit-inline" onclick="editScript(${index})">Edit</button>
                                        <button class="button button-small ${script.active ? 'deactivate' : 'activate'}" onclick="toggleScript(${index})">
                                            ${script.active ? '<?xml version="1.0" encoding="utf-8"?><svg width="14px" height="14px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 6C2 4.11438 2 3.17157 2.58579 2.58579C3.17157 2 4.11438 2 6 2C7.88562 2 8.82843 2 9.41421 2.58579C10 3.17157 10 4.11438 10 6V18C10 19.8856 10 20.8284 9.41421 21.4142C8.82843 22 7.88562 22 6 22C4.11438 22 3.17157 22 2.58579 21.4142C2 20.8284 2 19.8856 2 18V6Z" fill="currentColor"/><path d="M14 6C14 4.11438 14 3.17157 14.5858 2.58579C15.1716 2 16.1144 2 18 2C19.8856 2 20.8284 2 21.4142 2.58579C22 3.17157 22 4.11438 22 6V18C22 19.8856 22 20.8284 21.4142 21.4142C20.8284 22 19.8856 22 18 22C16.1144 22 15.1716 22 14.5858 21.4142C14 20.8284 14 19.8856 14 18V6Z" fill="currentColor"/></svg>' : '<?xml version="1.0" encoding="utf-8"?><svg width="14px" height="14px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21.4086 9.35258C23.5305 10.5065 23.5305 13.4935 21.4086 14.6474L8.59662 21.6145C6.53435 22.736 4 21.2763 4 18.9671L4 5.0329C4 2.72368 6.53435 1.26402 8.59661 2.38548L21.4086 9.35258Z" fill="currentColor"/></svg>'}
                                        </button>
                                    </div>
                                    <div class="script-modified">${script.created}</div>
                                    <div class="script-modified">${script.modified}</div>
                                    <div class="script-location">
                                        ${location_label} ${script.pages ? `${script.pages.replace(/,/g, ', ')}` : ''}
                                    </div>
                                </div>
                                <div class="script-actions">
                                    <button class="button" onclick="editScript(${index})"><?xml version="1.0" encoding="utf-8"?><svg width="14px" height="14px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M3.25 22C3.25 21.5858 3.58579 21.25 4 21.25H20C20.4142 21.25 20.75 21.5858 20.75 22C20.75 22.4142 20.4142 22.75 20 22.75H4C3.58579 22.75 3.25 22.4142 3.25 22Z" fill="currentColor"/><path d="M11.5201 14.929L11.5201 14.9289L17.4368 9.01225C16.6315 8.6771 15.6777 8.12656 14.7757 7.22455C13.8736 6.32238 13.323 5.36846 12.9879 4.56312L7.07106 10.4799L7.07101 10.48C6.60932 10.9417 6.37846 11.1725 6.17992 11.4271C5.94571 11.7273 5.74491 12.0522 5.58107 12.396C5.44219 12.6874 5.33894 12.9972 5.13245 13.6167L4.04356 16.8833C3.94194 17.1882 4.02128 17.5243 4.2485 17.7515C4.47573 17.9787 4.81182 18.0581 5.11667 17.9564L8.38334 16.8676C9.00281 16.6611 9.31256 16.5578 9.60398 16.4189C9.94775 16.2551 10.2727 16.0543 10.5729 15.8201C10.8275 15.6215 11.0584 15.3907 11.5201 14.929Z" fill="currentColor"/><path d="M19.0786 7.37044C20.3071 6.14188 20.3071 4.14999 19.0786 2.92142C17.85 1.69286 15.8581 1.69286 14.6296 2.92142L13.9199 3.63105C13.9296 3.6604 13.9397 3.69015 13.9502 3.72028C14.2103 4.47 14.701 5.45281 15.6243 6.37602C16.5475 7.29923 17.5303 7.78999 18.28 8.05009C18.31 8.0605 18.3396 8.07054 18.3688 8.08021L19.0786 7.37044Z" fill="currentColor"/></svg></button>
                                    <button class="button ${script.active ? 'button-secondary' : 'button-primary'}" onclick="toggleScript(${index})">
                                        ${script.active ? '<?xml version="1.0" encoding="utf-8"?><svg width="14px" height="14px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2 6C2 4.11438 2 3.17157 2.58579 2.58579C3.17157 2 4.11438 2 6 2C7.88562 2 8.82843 2 9.41421 2.58579C10 3.17157 10 4.11438 10 6V18C10 19.8856 10 20.8284 9.41421 21.4142C8.82843 22 7.88562 22 6 22C4.11438 22 3.17157 22 2.58579 21.4142C2 20.8284 2 19.8856 2 18V6Z" fill="currentColor"/><path d="M14 6C14 4.11438 14 3.17157 14.5858 2.58579C15.1716 2 16.1144 2 18 2C19.8856 2 20.8284 2 21.4142 2.58579C22 3.17157 22 4.11438 22 6V18C22 19.8856 22 20.8284 21.4142 21.4142C20.8284 22 19.8856 22 18 22C16.1144 22 15.1716 22 14.5858 21.4142C14 20.8284 14 19.8856 14 18V6Z" fill="currentColor"/></svg>' : '<?xml version="1.0" encoding="utf-8"?><svg width="14px" height="14px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M21.4086 9.35258C23.5305 10.5065 23.5305 13.4935 21.4086 14.6474L8.59662 21.6145C6.53435 22.736 4 21.2763 4 18.9671L4 5.0329C4 2.72368 6.53435 1.26402 8.59661 2.38548L21.4086 9.35258Z" fill="currentColor"/></svg>'}
                                    </button>
                                    <button class="button button-link-delete" onclick="deleteScript(${index})"><?xml version="1.0" encoding="iso-8859-1"?><svg fill="currentColor" height="14px" width="14px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" 	 viewBox="0 0 47.095 47.095" xml:space="preserve"><g>	<path d="M45.363,36.234l-13.158-13.16l12.21-12.21c2.31-2.307,2.31-6.049,0-8.358c-2.308-2.308-6.05-2.307-8.356,0l-12.212,12.21		L11.038,1.906c-2.309-2.308-6.051-2.308-8.358,0c-2.307,2.309-2.307,6.049,0,8.358l12.81,12.81L1.732,36.831		c-2.309,2.31-2.309,6.05,0,8.359c2.308,2.307,6.049,2.307,8.356,0l13.759-13.758l13.16,13.16c2.308,2.308,6.049,2.308,8.356,0		C47.673,42.282,47.672,38.54,45.363,36.234z"/></g></svg></button>
                                </div>
                            </div>
                        `;
                    }
                });
                $('#script-list').html(html || '<p class="no_results">No scripts found.</p>');
                if(selected_file === 'new_file'){
                    /*console.log('starter:' + selected_file);*/
                    $('.script-item').removeClass('selected');
                    $('.script-item:last-child button:first-child').click();
                }
                var selector_field = $("#element-selector").val();
                if(selector_field.length > 1){
                    $("#element-selector").css('display','flex');
                }
            }
        });
    }


    function addColorPreviews() {
        /*console.log('function: addColorPreviews() - RUNNING' );*/
        $('.ace_line').each(function() {
            const $line = $(this);
            const $propertySpan = $line.find('.ace_support.ace_type');
            const propertyText = $propertySpan.text();

            const colorProperties = ['background', 'color', 'border', 'box-shadow', 'text-shadow', 'outline'];

            if (colorProperties.some(prop => propertyText.includes(prop))) {
                /*console.log('property: ',propertyText,' - FOUND');*/
                const $colorSpan = $line.find('.ace_constant.ace_numeric, .ace_string');
                const colorText = $colorSpan.text();

                if (colorText) {
                    const $preview = $('<span>')
                                                .addClass('color-preview')
                                                .css({
                                                    display: 'inline-block',
                                                    width: '13px',
                                                    height: '13px',
                                                    marginLeft: '5px',
                                                    marginBottom: '-4px',
                                                    border: '1px solid #ffffff',
                                                    backgroundColor: colorText
                                                });
    
                    if ($(this).find('.color-preview').length > 0){
                        $('<span>').css({backgroundColor: colorText});
                    } else {
                        $line.append($preview);
                    }
                }
            }
        });
    }


    /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
    *
    *   LOOP START
    *
    * */

    function myLoop() {
        setTimeout(function(){
            addColorPreviews();
            myLoop();
        }, 1000 )
    }
    myLoop();

    window.toggleScript = function(index) {
        /*$('#script-list').html('');*/
        $('#hidden .loader_spinner').clone().appendTo("#script-list");
        $.post(csm_ajax.ajax_url, {
            action: 'toggle_custom_script',
            index: index,
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success) {
                updateScriptList();
            } else {
                alert('Failed to toggle script status.');
                $('#script-list .loader_spinner').detach();
            }
        });
    };
   
    window.editScript = function(index) {

        $('#editor').html('');
        /*$('#hidden .loader_spinner').clone().appendTo("#editor");*/
        $('#hidden .loader_spinner').clone().appendTo("#script-list");

        currentEditingIndex = index;
        $.post(csm_ajax.ajax_url, {
            action: 'edit_custom_script',
            index: index,
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success) {
                $('#script-list .loader_spinner').detach();

                selected_file = index;
                editor.destroy();

                const script = response.data;

                $('.script-item').removeClass('selected');
                $('#' + script.id).addClass('selected');

                $('#script-name').val(script.name);
                $('#script-type').val(script.type);
                $('#script-created').val(script.created);

                $('#script-position').val(script.position);
                $('#script-location').val(script.location);
                $('#script-pages').val(script.pages || '');
                $('#script-shortcode-id').val(script.shortcode_id || '');
                
                // Show/hide shortcode input based on location
                if (script.location === 'shortcode') {
                    $('#script-shortcode-id').show();
                    $('#script-pages').hide();
                } else {
                    $('#script-shortcode-id').hide();
                    $('#script-pages').show();
                }
                
                // Set option checkboxes
                $('#css-minimize').prop('checked', script.css_minimize || false);
                $('#js-base64').prop('checked', script.js_base64 || false);
                
                // Show/hide option checkboxes based on type
                if (script.type === 'css') {
                    $('#css-minimize-wrapper').show();
                    $('#js-base64-wrapper').hide();
                } else if (script.type === 'javascript') {
                    $('#css-minimize-wrapper').hide();
                    $('#js-base64-wrapper').show();
                } else {
                    $('#css-minimize-wrapper').hide();
                    $('#js-base64-wrapper').hide();
                }
                
                // Set context checkboxes
                $('.context-checkbox').prop('checked', false);
                if (script.context && Array.isArray(script.context)) {
                    script.context.forEach(function(contextValue) {
                        $('.context-checkbox[value="' + contextValue + '"]').prop('checked', true);
                    });
                } else if (script.context) {
                    // Handle legacy single context value
                    $('.context-checkbox[value="' + script.context + '"]').prop('checked', true);
                }
                // Update the hidden select
                const selectedContexts = [];
                $('.context-checkbox:checked').each(function() {
                    selectedContexts.push($(this).val());
                });
                $('#script-context').val(selectedContexts);

                // Update editor mode based on script type
                editor = ace.edit("editor");

                // 2. Unescape the JavaScript string (remove extra backslashes):
                //console.log(script.code);
                var encodedString = script.code;
                let tempDiv = document.createElement('div');
                tempDiv.innerHTML = encodedString;
                let htmlDecoded = tempDiv.textContent || tempDiv.innerText;

                //editor.setValue(htmlDecoded.replace(/\\'/g, "'"));
                editor.setValue(script.code);
                //editor.setTheme("ace/theme/vibrant_ink");
                editor.setTheme("ace/theme/chrome");
                //editor.setTheme("ace/theme/one_dark");

                var aceMode = "ace/mode/" + script.type;
                //console.log('aceMode:',aceMode); 

                editor.session.setMode(aceMode);
                editor.setOptions({
                    enableBasicAutocompletion: true,
                    enableSnippets: true,
                    enableLiveAutocompletion: true
                });

                // Scroll to editor
                $('html, body').animate({
                    scrollTop: $("#editor").offset().top - 50
                }, 500);

                selector_val = $("#script-type").val();
                checkScriptType_for_selector(selector_val);

                editor.clearSelection();
                // Update save button text
                $('#save-script').text('Save Changes');

                // Add history dropdown after script name
                const $historyControls = addHistoryDropdown(script.id);
                $('#script-name').after($historyControls);
            } else {
                alert('Failed to load script for editing.');
            }
        });
    };

    window.deleteScript = function(index) {
        $('#hidden .loader_spinner').clone().appendTo("#script-list");
        if (confirm('Are you sure you want to delete this script?')) {
            $.post(csm_ajax.ajax_url, {
                action: 'delete_custom_script',
                index: index,
                nonce: csm_ajax.nonce
            }, function(response) {
                if (response.success) {
                    updateScriptList();
                    if (currentEditingIndex === index) {
                        resetForm();
                    }
                    /*$('#script-list .loader_spinner').detach();*/
                } else {
                    alert('Failed to delete script.');
                    $('#script-list .loader_spinner').detach();
                }
            });
        } else {
            $('#script-list .loader_spinner').detach();
        }
    };


    $('.script-actions button.button').mousedown(function(e){
        $('.script-item').removeClass('selected');
        $(this).closest('.script-item').addClass('selected');
    });

    $('#save-script').click(function() {
        // Collect checked context values
        const contextValues = [];
        $('.context-checkbox:checked').each(function() {
            contextValues.push($(this).val());
        });
        
        const scriptData = {
            action: currentEditingIndex !== null ? 'update_custom_script' : 'save_custom_script',
            /*code: btoa(editor.getValue()), // Base64 encode*/
            code: btoa(String.fromCharCode(...new TextEncoder().encode(editor.getValue()))),
            name: $('#script-name').val(),
            type: $('#script-type').val(),
            position: $('#script-position').val(),
            created: $('#script-created').val(),
            location: $('#script-location').val(),
            pages: $('#script-pages').val(),
            shortcode_id: $('#script-shortcode-id').val(),
            selector: $('#element-selector').val(), // Add selector value
            context: contextValues, // Add context as array
            css_minimize: $('#css-minimize').is(':checked') ? 'true' : 'false',
            js_base64: $('#js-base64').is(':checked') ? 'true' : 'false',
            nonce: csm_ajax.nonce // Add nonce for CSRF protection
        };

        if (currentEditingIndex !== null) {
            scriptData.index = currentEditingIndex;
        }
        
        $('#hidden .loader_spinner').clone().appendTo("#script-list");
        $.post(csm_ajax.ajax_url, scriptData, function(response) {
            if (response.success) {
                updateScriptList();
                // After successful save, re-fetch the script to get its ID
                $.post(csm_ajax.ajax_url, {
                    action: 'edit_custom_script',
                    index: currentEditingIndex !== null ? currentEditingIndex : $('.script-item').length - 1,
                    nonce: csm_ajax.nonce
                }, function(response) {
                    if (response.success) {
                        // Remove existing history dropdown
                        $('#script-history').fadeOut().val('');
                        $('#clear-history').fadeOut();
                        // Add new history dropdown
                        const $historyControls = addHistoryDropdown(response.data.id);
                        $('#script-name').after($historyControls);
                    }
                });
            } else {
                alert('Failed to save script.');
            }
            $('#script-list .loader_spinner').detach();
        });
    });

    // Add type buttons functionality
    $('#add-javascript, #add-html, #add-php, #add-css').click(function() {
        selected_file = 'new_file';
        const type = this.id.replace('add-', '');
        resetForm();
        $('.script-item').removeClass('selected');
        $('#script-type').val(type);
        editor.session.setMode("ace/mode/" + type);

        /* */
        var default_code = '';
        if(type=='javascript'){
            default_code =  `/*\n`;
            default_code += `\n`;
            default_code += `   document.addEventListener('DOMContentLoaded', function() {\n`;
            default_code += `   or\n`;
            default_code += `   jQuery(document).ready(function( $ ){\n`;
            default_code += `\n`;
            default_code += `       //-- Your code here... \n`;
            default_code += `\n`;
            default_code += `   })\n`;
            default_code += `\n`;
            default_code += `*/\n`;
        } else if(type=='php'){
            default_code =  `<?php/*\n`;
            default_code += `\n`;
            default_code += `   Adding code here is similar to adding code to the theme's functions.php\n`;
            default_code += `\n`;
            default_code += `   1. No need for a child theme.\n`;
            default_code += `   2. You CAN add shortcode and filter definitions the same way you would to the functions.php.\n`;
            default_code += `   3. You do NOT need to wrap the code with 'add_filter' or 'add_shortcode'.\n`;
            default_code += `\n`;
            default_code += `*/?>\n`;
        }
        editor.setValue(default_code);
    });

    // Script type change handler
    $('#script-position').change(function() {
        var scr_pos = $('#script-position').val();
        if(scr_pos==='element'){
            $("#element-selector").css('display','flex');
        }else{
            $("#element-selector").css('display','none');
            $("#element-selector").val('');
        }
    });

    // Script type change handler
    $('#script-type').change(function() {
        var selector_val = $(this).val();
        editor.session.setMode("ace/mode/" + selector_val);
        checkScriptType_for_selector(selector_val);
        
        // Show/hide option checkboxes based on type
        if (selector_val === 'css') {
            $('#css-minimize-wrapper').show();
            $('#js-base64-wrapper').hide();
        } else if (selector_val === 'javascript') {
            $('#css-minimize-wrapper').hide();
            $('#js-base64-wrapper').show();
        } else {
            $('#css-minimize-wrapper').hide();
            $('#js-base64-wrapper').hide();
        }
    });
    
    // Script location change handler
    $('#script-location').change(function() {
        var location_val = $(this).val();
        if (location_val === 'shortcode') {
            $('#script-shortcode-id').show();
            $('#script-pages').hide();
        } else {
            $('#script-shortcode-id').hide();
            $('#script-pages').show();
        }
    });

    // Context checkbox change handler
    $('.context-checkbox').change(function() {
        const selectedContexts = [];
        $('.context-checkbox:checked').each(function() {
            selectedContexts.push($(this).val());
        });
        $('#script-context').val(selectedContexts);
    });

    function checkScriptType_for_selector(selector_val){
        if(selector_val==='php'){
            $("#element-selector").css('display','none');
            $("#element-selector").val('');
            $('#script-position option[value="element"]').attr('hidden',true);
            $('#script-position option[value="body_top"]').prop('selected',true);

            var pos_now = $('#script-position').val();
            if(pos_now==='element'){
                $('#script-position option[value="body_top"]').prop('selected',true);
            }
        } else {
            var pos_now = $('#script-position').val();
            if(pos_now==='element'){
                $("#element-selector").css('display','flex');
                $('#script-position option[value="element"]').attr('hidden',false);
            } else {
                $("#element-selector").css('display','none');
                $('#script-position option[value="element"]').attr('hidden',false);
            }
        }
    }

    $(".script_search").on("keyup",function(){
        search_value = $(".script_search").val();
        console.log('search_value::' + search_value + "----LL:" + search_value.length);
        if(search_value.length > 0){
            $(".clear_search").css('display','flex');
        } else {
            $(".clear_search").css('display','none');
        }
        updateScriptList(search_value);
        
    });

    $(".clear_search").click(function(){
        $(".clear_search").css('display','none');
        $(".script_search").val('').trigger('input').trigger('change');
        search_value = '';
        updateScriptList(search_value);
    });

    // Initialize script list
    updateScriptList();

    $('#add-javascript').click();
    
    // Initialize option checkboxes visibility based on script type
    var currentType = $('#script-type').val();
    if (currentType === 'css') {
        $('#css-minimize-wrapper').show();
        $('#js-base64-wrapper').hide();
    } else if (currentType === 'javascript') {
        $('#css-minimize-wrapper').hide();
        $('#js-base64-wrapper').show();
    } else {
        $('#css-minimize-wrapper').hide();
        $('#js-base64-wrapper').hide();
    }

    /* .type_wrapper button:hover + .type_wrapper .type_controls { */
    $('.type_wrapper').on('mouseenter', 'button', function(event) {
        $(this).closest('.type_wrapper').find('.type_controls').css('display', 'flex');
    });
    $('.type_wrapper').on('mouseleave', function(event) {
        $(this).closest('.type_wrapper').find('.type_controls').css('display', 'none');
    });



    $('.font_size.fs10').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','10px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs11').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','11px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs12').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','12px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs13').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','13px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs14').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','14px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs15').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','15px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs16').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','16px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });
    $('.font_size.fs17').click(function(){
        console.log('fs++');
        $('.ace_editor').css('font-size','17px');
        $('.font_size').css('color','var(--position-location)');
        $('.font_size').css('background','#000000');
        $('.font_size').css('opacity','1');
        $(this).css('background','var(--position-location)');
        $(this).css('color','#FFFFFF');
        $(this).css('opacity','0.6');
    });



    /***w sho hide scripts */

    var js_show_state = 0;
    var js_hide_state = 0;
    var css_show_state = 0;
    var css_hide_state = 0;
    var html_show_state = 0;
    var html_hide_state = 0;
    var php_show_state = 0;
    var php_hide_state = 0;

    $('#show-javascript').click(function(){

        css_show_state = 0;
        css_hide_state = 0;
        html_show_state = 0;
        html_hide_state = 0;
        php_show_state = 0;
        php_hide_state = 0;

        if(js_show_state == 0) {
            $('.script-item').css('display','none');
            $('.JS').css('display','flex');
            $('.show').css('background','transparent');
            $('#scr-javascript .show').css('background','var(--input-color-1)');
            $('.scr-javascript .show').css('background','var(--input-color-1)');
            js_show_state = 1;
            js_hide_state = 0;
            $('.hide').css('background','transparent');
        } else {
            $('.script-item').css('display','flex');
            $('.show').css('background','transparent');
            js_show_state = 0;
        }
    });
    $('#hide-javascript').click(function(){

        css_show_state = 0;
        css_hide_state = 0;
        html_show_state = 0;
        html_hide_state = 0;
        php_show_state = 0;
        php_hide_state = 0;

        if(js_hide_state == 0) {
            $('.script-item').css('display','flex');
            $('.hide').css('background','transparent');
            $('#scr-javascript .hide').css('background','var(--input-color-1)');
            $('.scr-javascript .hide').css('background','var(--input-color-1)');
            $('.JS').css('display','none');
            js_hide_state = 1;
            js_show_state = 0;
            $('.show').css('background','transparent');
        } else {
            $('.JS').css('display','flex');
            $('.hide').css('background','transparent');
            js_hide_state = 0;
        }
    });

    $('#show-css').click(function(){

        js_show_state = 0;
        js_hide_state = 0;
        html_show_state = 0;
        html_hide_state = 0;
        php_show_state = 0;
        php_hide_state = 0;
    
        if(css_show_state == 0) {
            $('.script-item').css('display','none');
            $('.CSS').css('display','flex');
            $('.show').css('background','transparent');
            $('#scr-css .show').css('background','var(--input-color-1)');
            $('.scr-css .show').css('background','var(--input-color-1)');
            css_show_state = 1;
            css_hide_state = 0;
            $('.hide').css('background','transparent');
        } else {
            $('.script-item').css('display','flex');
            $('.show').css('background','transparent');
            css_show_state = 0;
        }
    });
    $('#hide-css').click(function(){

        js_show_state = 0;
        js_hide_state = 0;
        html_show_state = 0;
        html_hide_state = 0;
        php_show_state = 0;
        php_hide_state = 0;

        if(css_hide_state == 0) {
            $('.script-item').css('display','flex');
            $('.hide').css('background','transparent');
            $('#scr-css .hide').css('background','var(--input-color-1)');
            $('.scr-css .hide').css('background','var(--input-color-1)');
            $('.CSS').css('display','none');
            css_hide_state = 1;
            css_show_state = 0;
            $('.show').css('background','transparent');
        } else {
            $('.CSS').css('display','flex');
            $('.hide').css('background','transparent');
            css_hide_state = 0;
        }
    });

    $('#show-html').click(function(){

        js_show_state = 0;
        js_hide_state = 0;
        css_show_state = 0;
        css_hide_state = 0;
        php_show_state = 0;
        php_hide_state = 0;

        if(html_show_state == 0) {
            $('.script-item').css('display','none');
            $('.HTML').css('display','flex');
            $('.show').css('background','transparent');
            $('#scr-html .show').css('background','var(--input-color-1)');
            $('.scr-html .show').css('background','var(--input-color-1)');
            html_show_state = 1;
            html_hide_state = 0;
            $('.hide').css('background','transparent');
        } else {
            $('.script-item').css('display','flex');
            $('.show').css('background','transparent');
            html_show_state = 0;
        }
    });
    $('#hide-html').click(function(){

        js_show_state = 0;
        js_hide_state = 0;
        css_show_state = 0;
        css_hide_state = 0;
        php_show_state = 0;
        php_hide_state = 0;

        if(html_hide_state == 0) {
            $('.script-item').css('display','flex');
            $('.hide').css('background','transparent');
            $('#scr-html .hide').css('background','var(--input-color-1)');
            $('.scr-html .hide').css('background','var(--input-color-1)');
            $('.HTML').css('display','none');
            html_hide_state = 1;
            html_show_state = 0;
            $('.show').css('background','transparent');
        } else {
            $('.HTML').css('display','flex');
            $('.hide').css('background','transparent');
            html_hide_state = 0;
        }
    });

    $('#show-php').click(function(){

        js_show_state = 0;
        js_hide_state = 0;
        css_show_state = 0;
        css_hide_state = 0;
        html_show_state = 0;
        html_hide_state = 0;

        if(php_show_state == 0) {
            $('.script-item').css('display','none');
            $('.PHP').css('display','flex');
            $('.show').css('background','transparent');
            $('#scr-php .show').css('background','var(--input-color-1)');
            $('.scr-php .show').css('background','var(--input-color-1)');
            php_show_state = 1;
            php_hide_state = 0;
            $('.hide').css('background','transparent');
        } else {
            $('.script-item').css('display','flex');
            $('.show').css('background','transparent');
            php_show_state = 0;
        }
    });
    $('#hide-php').click(function(){

        js_show_state = 0;
        js_hide_state = 0;
        css_show_state = 0;
        css_hide_state = 0;
        html_show_state = 0;
        html_hide_state = 0;

        if(php_hide_state == 0) {
            $('.script-item').css('display','flex');
            $('.hide').css('background','transparent');
            $('#scr-php .hide').css('background','var(--input-color-1)');
            $('.scr-php .hide').css('background','var(--input-color-1)');
            $('.PHP').css('display','none');
            php_hide_state = 1;
            php_show_state = 0;
            $('.show').css('background','transparent');
        } else {
            $('.PHP').css('display','flex');
            $('.hide').css('background','transparent');
            php_hide_state = 0;
        }
    });


    /**** split screen size */

    /*
    let isDragging = false;

    $(".split_resize").on("click", function (e) {
        isDragging = true;
        let $listWrapper = $(".list_wrapper");
        let parentWidth = $listWrapper.parent().width();
        $("body").css("cursor", "ew-resize"); // Change cursor

        $(document).on("mousemove", function (e) {
            if (!isDragging) return;
            let newWidth = (e.pageX / parentWidth) * 100;
            newWidth = Math.max(50, Math.min(200, newWidth));
            $listWrapper.css("width", newWidth + "%");
        });

        $(document).on("mouseup", function () {
            $("body").css("cursor", "default"); // Change cursor
            isDragging = false;
            $(document).off("mousemove mouseup");
        });
    });
    */

    var layout_state = 1;
    $(".layout_toggle").click(function(){
        if(layout_state===1){
            $(".list_wrapper").css('width','0%');
            $(".list_wrapper").css('opacity','0');
            $(".layout_toggle").addClass('closed');
            layout_state = 0;
        } else {
            $(".list_wrapper").css('width','80%');
            $(".list_wrapper").css('opacity','1');
            $(".layout_toggle").removeClass('closed');
            layout_state = 1;
        }
    });

    /***************************/

    $(document).on('click', '.move-up, .move-down', function(e) {
        console.log('u/d');
        e.preventDefault();
        e.stopPropagation();
        const $scriptItem = $(this).closest('.script-item');
        const direction = $(this).hasClass('move-up') ? 'up' : 'down';
        const currentIndex = $scriptItem.index();
        
        // Show loading spinner
        $('#hidden .loader_spinner').clone().appendTo("#script-list");
        
        $.post(csm_ajax.ajax_url, {
            action: 'reorder_custom_script',
            index: currentIndex,
            direction: direction,
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success) {
                updateScriptList();
            } else {
                alert('Failed to reorder script.');
                $('#script-list .loader_spinner').detach();
            }
        });
    });

    // Modify the addHistoryDropdown function
    function addHistoryDropdown(scriptId) {
        const currentDate = new Date().toLocaleString();
        
        $('#script-history').detach();
        $('#clear-history').detach();

        const $wrapper = $('<div>')
            .addClass('history-controls')
            .css({
                'display': 'flex',
                'gap': '5px',
                'align-items': 'center',
                'margin': '10px 5px'
            });

        const $clearButton = $('<button>')
            .attr('id', 'clear-history')
            .addClass('button button-link-delete')
            .html('Clear<br>History')
            .css({
                'padding': '4px 8px',
                'min-height': '30px',
                'height': '30px'
            })
            .on('click', function() {
                if (confirm('Are you sure you want to clear the history for this script? This cannot be undone.')) {
                    clearScriptHistory(scriptId);
                }
            });

        const $historySelect = $('<select>')
            .attr('id', 'script-history')
            .addClass('script-control')
            .css('display', 'none')
            .on('change', function() {
                if (this.value) {
                    loadVersion(scriptId, this.value);
                    $(this).val('');
                }
            });
        
        // Add current version as default option
        $historySelect.append($('<option>').val('').text('Current: ' + currentDate));
        
        // Get history for this script
        $.post(csm_ajax.ajax_url, {
            action: 'get_script_history',
            script_id: scriptId,
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success && response.data.length > 0) {
                const sortedVersions = response.data.sort((a, b) => {
                    return new Date(b.timestamp) - new Date(a.timestamp);
                });
                
                sortedVersions.forEach(version => {
                    const date = new Date(version.timestamp);
                    const formattedDate = date.toLocaleString();
                    $historySelect.append(
                        $('<option>')
                            .val(version.timestamp)
                            .text('Version: ' + formattedDate)
                    );
                });
                $historySelect.fadeIn();
                $clearButton.fadeIn();
            }
        });
        
        $wrapper.append($clearButton, $historySelect);
        return $wrapper;
    }

    // Add the clearScriptHistory function
    function clearScriptHistory(scriptId) {
        $.post(csm_ajax.ajax_url, {
            action: 'clear_script_history',
            script_id: scriptId,
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success) {
                // Remove history dropdown and clear button
                $('#script-history').fadeOut().val('');
                $('#clear-history').fadeOut();
            } else {
                alert('Failed to clear history');
            }
        });
    }

    // Modify loadVersion function
    function loadVersion(scriptId, versionTimestamp) {
        $.post(csm_ajax.ajax_url, {
            action: 'get_script_version',
            script_id: scriptId,
            version: versionTimestamp,
            nonce: csm_ajax.nonce
        }, function(response) {
            if (response.success) {
                const version = response.data;
                
                // Update editor content
                editor.setValue(version.code);
                editor.clearSelection();
                
                // Update form fields
                $('#script-name').val(version.name);
                $('#script-type').val(version.type);
                $('#script-position').val(version.position);
                $('#script-location').val(version.location);
                $('#script-pages').val(version.pages);
                $('#element-selector').val(version.selector || '');
                
                // Set context checkboxes
                $('.context-checkbox').prop('checked', false);
                if (version.context && Array.isArray(version.context)) {
                    version.context.forEach(function(contextValue) {
                        $('.context-checkbox[value="' + contextValue + '"]').prop('checked', true);
                    });
                } else if (version.context) {
                    // Handle legacy single context value
                    $('.context-checkbox[value="' + version.context + '"]').prop('checked', true);
                }
                // Update the hidden select
                const selectedContexts = [];
                $('.context-checkbox:checked').each(function() {
                    selectedContexts.push($(this).val());
                });
                $('#script-context').val(selectedContexts);
                
                // Update editor mode based on script type
                editor.session.setMode("ace/mode/" + version.type);
                
                // Show/hide element selector if needed
                checkScriptType_for_selector(version.type);
                
                // Update save button to indicate unsaved changes
                $('#save-script').text('Save Changes');

                // Update dropdown text to show selected version
                const date = new Date(version.timestamp);
                const formattedDate = date.toLocaleString();
                $('#script-history option:first').text('Selected: ' + formattedDate);

                // Add one-time handler for editor changes
                const onChangeHandler = function() {
                    const currentDate = new Date().toLocaleString();
                    $('#script-history option:first').text('Current: ' + currentDate);
                    // Remove the change handler after first use
                    editor.off('change', onChangeHandler);
                };
                editor.on('change', onChangeHandler);

            } else {
                alert('Failed to load version');
            }
        });
    }
});
